/*
 *  Copyright (c) by CryptoSoft GmbH 1998-2015^M
 *  All Rights Reserved^M
 *  Licensed Material - Property of CryptoSoft GmbH^M
 *  This software is made available solely pursuant to the^M
 *  terms of a license agreement which governs its use.^M
 *^M
 *  Sample source for ECB mode benchmark 
 */

#if defined(WIN16) || defined(WIN32) || defined(WIN64)

#include <windows.h>

#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/timeb.h>
#include "blowfish.h"

#define BLKSZ  (8)
#define NUMBLK (1000)

static char *algo = "16 round Blowfish";

static unsigned long bufsize = BLKSZ * NUMBLK;
static unsigned long rounds  = BLKSZ * NUMBLK;

static BLOWFISH_KS ks;

int main(int argc, char **argv)
{
  register unsigned char *b, *buf;
  register unsigned int  i, j;
  struct timeb t, t1;
  float ms;

  if ((buf = (unsigned char *) malloc(bufsize)) == NULL) {
    fprintf(stderr,"%s: Error: Cannot alloc memory !\n", argv[0]);
    return 1;
  }
  ftime(&t);
  for (j = 0; j < rounds; j++)
  for (b=buf, i = bufsize; i > 0; i -= BLKSZ , b += BLKSZ) blowfish_ecbencode(b,b,&ks);
  ftime(&t1);
  ms = (float)((t1.time * 1000L + t1.millitm) - (t.time * 1000L + t.millitm)) / 1000;
  printf("Throughput %ld bytes/s for %s (ECB mode)\n", (unsigned long)(rounds*bufsize/ms), algo);
  free(buf);
  return 0;
}
