/*
 *  Copyright (c) by CryptoSoft GmbH 1996-2014^M
 *  All Rights Reserved^M
 *  Licensed Material - Property of CryptoSoft GmbH^M
 *  This software is made available solely pursuant to the^M
 *  terms of a license agreement which governs its use.^M
 *^M
 *  TESTVK.C - Cast-128 Variable Key Known Answer Test
 */

#if defned(WIN32) || defined(WIN64)
#include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include "cast128.h"	 /* Cast-128 function prototypes */

/* size of key, in bytes */
#define KEYSZ	(16)
/* size of standard block, in bytes */
#define	BLKSZ	(8)

static char *algo = "Cast-128";

CAST128_KS ks;

int main(void)
{
  unsigned char kb[KEYSZ];
  unsigned char pt[BLKSZ], ct[BLKSZ], rt[BLKSZ];
  unsigned int i,j;

  printf("Electronic Codebook (ECB) Mode\nVariable Key Known Answer Tests\n");
  printf("Algorithm: %s\nKeysize=%u Bits\n", algo, KEYSZ*8);

  memset(pt, 0, BLKSZ);
  printf("\nPT=");
  for (j=0; j < BLKSZ; j++) printf("%02x", pt[j]);

  for (i = 0; i < KEYSZ * 8; i++) {
    memset(kb, 0, KEYSZ);
    kb[i/8] = 0x80 >> i%8;
    cast128_init(kb, KEYSZ, &ks);
    cast128_ecbencode(pt, ct, &ks);
    printf("\n\nI=%u\nKEY=", i+1);
    for (j=0; j < KEYSZ; j++) printf("%02x", kb[j]);
    printf("\nCT=");
    for (j=0; j < BLKSZ; j++) printf("%02x", ct[j]);
    cast128_ecbdecode(ct, rt, &ks);
    if (memcmp(pt,rt,BLKSZ)) {
      fprintf(stderr, "\n*** Decryption for round %d failed ***\n", i);
      fprintf(stderr, "\nKEY=");
      for (j=0; j < KEYSZ; j++) fprintf(stderr, "%02x", kb[j]);
      fprintf(stderr, "\nCT=");
      for (j=0; j < BLKSZ; j++) fprintf(stderr, "%02x", ct[j]);
      fprintf(stderr, "\nPT=");
      for (j=0; j < BLKSZ; j++) fprintf(stderr, "%02x", rt[j]);
      fprintf(stderr, "\nOT=");
      for (j=0; j < BLKSZ; j++) fprintf(stderr, "%02x", pt[j]);
      fprintf(stderr,"\n\nNot Succeeded ...\n");
      return 1;
    }
  }
  printf("\n\nSucceeded ...\n");
  return 0;
}
