/*
 *  Copyright (c) by CryptoSoft GmbH 1998-2015
 *  All Rights Reserved
 *  Licensed Material - Property of CryptoSoft GmbH
 *  This software is made available solely pursuant to the
 *  terms of a license agreement which governs its use.
 *
 *  Sample source for ECB mode benchmark 
 */

#ifdef WIN32
#include <windows.h>
#endif

#ifdef WIN64
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/timeb.h>
#include "cast128.h"

#define BLKSZ  (8)
#define NUMBLK (1000)

static char *algo = "16 round Cast-128" ;

static size_t bufsize = BLKSZ * NUMBLK;
static size_t rounds  = BLKSZ * NUMBLK;

static CAST128_KS ks;

int main(int argc, char **argv)
{
  register unsigned char *b, *buf;
  register size_t i, j;
  struct timeb t, t1;
  float ms;

  if ((buf = (unsigned char *) malloc(bufsize)) == NULL) {
    fprintf(stderr,"%s: Error: Cannot alloc memory !\n", argv[0]);
    return 1;
  }
  ftime(&t);
  for (j = 0; j < rounds; j++)
  for (b=buf, i = bufsize; i > 0; i -= BLKSZ , b += BLKSZ) cast128_ecbencode(b,b,&ks);
  ftime(&t1);
  ms = (((float)(t1.time * 1000) + t1.millitm) - ((float)(t.time * 1000) + t.millitm)) / 1000;
  printf("Throughput %lu bytes/s for %s (ECB mode)\n", (unsigned long)(((float)rounds*bufsize)/ms), algo);
  free(buf);
  return 0;
}
