/*
 *  Copyright (c) by CryptoSoft GmbH 1998-2015^M
 *  All Rights Reserved^M
 *  Licensed Material - Property of CryptoSoft GmbH^M
 *  This software is made available solely pursuant to the^M
 *  terms of a license agreement which governs its use.^M
 *^M
 *  this sample source will give you an idea on how to
 *  call up the various library functions. -
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include "cast128.h"

#define BUFSIZE 16384

#define KEYSZ (16)
#define BLKSZ ( 8)

static char *algo = "16 round Cast-128";
static char *usage = "[-]{d|e} infile outfile key";
static CAST128_KS ks;


int main(int argc, char **argv)
{
  register unsigned char *b, *buf, c;
  static unsigned char key[KEYSZ];
  register int i, mode, bytes;
  static int l = 0;
  register time_t t, t1;
  FILE *ih, *oh;

  if(argc == 5) {
    switch (c = *argv[1] == '-' ? *++argv[1] : *argv[1]) {
      case 'e': case 'E': mode = 0; break;
      case 'd': case 'D': mode = 1; break;
      default : fprintf(stderr,"%s : illegal option %c \n", argv[0], c);
   	   	fprintf(stderr,"Usage : %s %s \n", argv[0], usage);
   	   	return 1;
    }
  } else {
    fprintf(stderr, "Usage : %s %s \n", argv[0], usage);
    return 1;
  }
  
  if ((buf = (unsigned char *) malloc(BUFSIZE)) == NULL) {
    fprintf(stderr,"%s: Error: Cannot alloc memory !\n", argv[0]);
    return 1;
  }
  ih =  fopen(argv[2],"rb");
  oh = fopen(argv[3],"wb");
  if (ih == NULL || oh == NULL) {
    perror(ih ? argv[3]:argv[2]);
    return 1;
  }
  memset(key,0,KEYSZ);
  bytes = strlen(argv[4]);
  memcpy(key, argv[4], bytes > KEYSZ - 1 ? KEYSZ: bytes);
  cast128_init(key, KEYSZ, &ks);
  t = time(NULL);
  while ((i = fread(buf,1,BUFSIZE,ih)) != 0) {
    for (b=buf, bytes=i; i > 0; i -= BLKSZ , b += BLKSZ) {
      if (mode == 0) {
        if (i < BLKSZ) {
          bytes += BLKSZ-i;
          l = i;
        }
        cast128_ecbencode(b,b,&ks); 
      } else {
        if (i > BLKSZ - 1) {
          cast128_ecbdecode(b,b,&ks); 
        } else bytes -= (BLKSZ + 1 - (b[0] & 0xff));
      }
    }
    if (fwrite(buf, 1, bytes, oh) != (size_t) bytes) {
      fprintf(stderr,"%s: Error in write !\n", argv[0]);
      return 1;
    }
  }
  if (mode == 0) fputc(l ? l : l + BLKSZ, oh);
  t1 = time(NULL) - t;
  printf("%scrypted bytes per second using %s: %ld\n", mode ? "De":"En", algo, ftell(ih)/(t1 ? t1 : 1));
  fclose(ih);
  fclose(oh);
  return 0;
}
