/*
 *  Copyright (c) 1998-2014 by CryptoSoft GmbH
 *  All Rights Reserved
 *  Licensed Material - Property of CryptoSoft GmbH
 *  This software is made available solely pursuant to the
 *  terms of a CryptoSoft license agreement which governs its use.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include "des3.h"

#define BUFSIZE 16384

#define KEYSZ  ( 8)
#define KEY3SZ (24)
#define BLKSZ  ( 8)

static char *algo  = "16 round DES";
static char *usage = "[-]{d|e}[3] infile outfile key";
static DES_KS ks1, ks2, ks3;

int main(int argc, char **argv)
{
  register unsigned char *b, *buf, c;
  static unsigned char key[KEYSZ], key3[KEY3SZ];
  register int i, three, mode, bytes;
  static int l = 0;
  register time_t t, t1;
  FILE *ih, *oh;
  if(argc == 5) {
    switch (c = *argv[1] == '-' ? *++argv[1] : *argv[1]) {
      case 'e': case 'E': mode = 0; break;
      case 'd': case 'D': mode = 1; break;
      default : fprintf(stderr,"%s : illegal option %c \n", argv[0], c);
   	   	fprintf(stderr,"Usage : %s %s \n", argv[0], usage);
   	   	return 1;
    }
    switch(*++argv[1]) {
      case '3': three = 1; break;
      default : three = 0;
    }
  } else {
    fprintf(stderr,"Usage : %s %s \n", argv[0], usage);
    return 1;
  }
  if ((buf = (unsigned char *) malloc(BUFSIZE)) == NULL) {
    fprintf(stderr,"%s: Error: Cannot alloc memory !\n", argv[0]);
    return 1;
  }
  ih =  fopen(argv[2],"rb");
  oh = fopen(argv[3],"wb");
  if (ih == NULL || oh == NULL) {
    perror(ih ? argv[3]:argv[2]);
    return 1;
  }
  if (three == 0) {
    memset(key,0,KEYSZ);
    bytes = strlen(argv[4]);
    memcpy(key,argv[4],bytes > KEYSZ - 1 ? KEYSZ:bytes);
    des_init(key, ks1);
  } else {
    memset(key3,0,KEY3SZ);
    bytes = strlen(argv[4]);
    memcpy(key3,argv[4],bytes > KEY3SZ - 1 ? KEY3SZ:bytes);
    des_3EEEinit(key3, ks1, ks2, ks3);
  }
  t = time(NULL);
  while ((i = fread(buf,1,BUFSIZE,ih)) != 0) {
    for (b=buf, bytes=i; i > 0; i -= BLKSZ , b += BLKSZ) {
      if (mode == 0) {
        if (i < BLKSZ) {
          bytes += BLKSZ-i;
          l = i;
        }
        if (three == 0) des_ecbencode(b,b,ks1); else des_ecb3EEEencode(b,b,ks1,ks2,ks3);
      } else {
        if (i > BLKSZ - 1) {
          if (three == 0) des_ecbdecode(b,b,ks1); else des_ecb3EEEdecode(b,b,ks1,ks2,ks3);
        } else bytes -= (BLKSZ + 1 - (b[0] & 0xff));
      }
    }
    if (fwrite(buf, 1, bytes, oh) != (size_t) bytes) {
      fprintf(stderr,"%s: Error in write !\n", argv[0]);
      return 1;
    }
  }
  if (mode == 0) fputc(l ? l : l + BLKSZ, oh);
  t1 = time(NULL) - t;
  printf("%scrypted bytes per second using %s %s: %ld\n", mode ? "De":"En",
          three == 0 ? "single" : "triple" , algo, ftell(ih)/(t1 ? t1 : 1));
  fclose(ih);
  fclose(oh);
  return 0;
}
