/*
 *  Copyright (c) 1998-2014 by CryptoSoft GmbH
 *  All Rights Reserved
 *  Licensed Material - Property of CryptoSoft GmbH
 *  This software is made available solely pursuant to the
 *  terms of a CryptoSoft license agreement which governs its use.
 */

#include <windows.h>
#include <stdio.h>
#include <string.h>
#if !defined(_WIN32) && !defined(WIN32)
#include <ver.h>
#endif
#include "des3.h"  /* DES function prototypes */

/* size of key, in bytes */
#define KEYSZ   (8)
/* size of standard block, in bytes */
#define BLKSZ   (8)

static char *algo = "DES";

DES_KS ks;


static char *szAppName = "TESTVT";
static char *szTitle   = "Electronic Codebook (ECB) Mode - Variable Text Known Answer Tests";

#if !defined (APIENTRY)
#define APIENTRY PASCAL
#endif

BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

HINSTANCE hInst;

#ifdef __TURBOC__
#pragma argsused
#endif
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  MSG msg;
  if (!hPrevInstance) {
    if (!InitApplication(hInstance)) {
      return (FALSE);
    }
  }
  if (!InitInstance(hInstance, nCmdShow)) {
    return (FALSE);
  }
  while (GetMessage(&msg,NULL,0,0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return (msg.wParam);
}

BOOL InitApplication(HINSTANCE hInstance)
{
  WNDCLASS  wc;

  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = (WNDPROC)WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, szAppName);
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = szAppName;
  return (RegisterClass(&wc));
}

#ifdef __TURBOC__
#pragma argsused
#endif
BOOL InitInstance(HINSTANCE hInstance,int nCmdShow)
{
  HWND hWnd;
  hInst = hInstance;
  hWnd = CreateWindow(szAppName,szTitle, WS_OVERLAPPEDWINDOW, 0, 0, 0, 0, NULL, NULL, hInstance, NULL);
  if (!hWnd) return (FALSE);
  PostMessage(hWnd, WM_COMMAND, WM_USER + 100, 0L);
  return (TRUE);
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam)
{
  int wmId;

  switch (message) {
     case WM_COMMAND:
#if defined (_WIN32) || defined(WIN32)
       wmId    = LOWORD(uParam);
#else
       wmId    = uParam;
#endif
       switch (wmId) {
         case WM_USER + 100:
           {
             static unsigned char kb[KEYSZ];
             static unsigned char pt[BLKSZ], ct[BLKSZ], rt[BLKSZ];
             static unsigned char a[4096], b[1024], c[1024];
             unsigned int i,j;

             sprintf(a, "Algorithm: %s\nKeysize=%u Bits\n", algo, KEYSZ*8);
             memset(kb, 0, KEYSZ);
             wsprintf(b,"\nKEY=");
             lstrcat(a, b);
             for (j=0; j < KEYSZ; j++) {
               wsprintf(b, "%02x", kb[j]);
               lstrcat(a, b);
             }
             for (i = 0; i < BLKSZ * 8; i++) {
               memset(pt, 0, BLKSZ);
               pt[i/8] = 0x80 >> i%8;
               des_init(kb, KEYSZ, ks);
               des_ecbencode(pt, ct, ks);
               wsprintf(b,"\n\nI=%u\nPT=", i+1);
               for (j=0; j < BLKSZ; j++) {
                 wsprintf(c, "%02x", pt[j]);
                 lstrcat(b,c);
               }
               wsprintf(c,"\nCT=");
               lstrcat(b,c);
               for (j=0; j < BLKSZ; j++) {
                 wsprintf(c,"%02x", ct[j]);
                 lstrcat(b,c);
               }
               if (!i) lstrcat(a, b);
               des_ecbdecode(ct, rt, ks);
               if (memcmp(pt,rt,BLKSZ)) {
                 static unsigned char a[1024], b[1024], c[1024], d[1024], e[2048];
                 for (j=0; j < KEYSZ; j++) {
                   wsprintf(e, "%02x", kb[j]);
                   lstrcat(a,e);
                 }
                 for (j=0; j < BLKSZ; j++) {
                   wsprintf(e, "%02x", pt[j]);
                   lstrcat(b,e);
                 }
                 for (j=0; j < BLKSZ; j++) {
                   wsprintf(e,"%02x", ct[j]);
                   lstrcat(c,e);
                 }
                 for (j=0; j < BLKSZ; j++) {
                   wsprintf(e,"%02x", rt[j]);
                   lstrcat(d,e);
                 }
                 wsprintf(e, "*** Decryption for round %d failed ***\n\nKey=%s\nCT=%s\nPT=%s\nOT=%s", i, a, c, d, b);
                 MessageBox(hWnd, e, szTitle, MB_ICONHAND);
                 SendMessage(hWnd, WM_DESTROY, 0, 0L);
                 return (DefWindowProc(hWnd, message, uParam, lParam));
               }
             }
             lstrcat(a,"\n.\n.\n.");
             lstrcat(a, b);
             lstrcat(a,"\n\nSucceeded ...");
             MessageBox(hWnd, a, szTitle, MB_OK);
           }
           SendMessage(hWnd, WM_DESTROY, 0, 0L);
           break;
         default:
           return (DefWindowProc(hWnd, message, uParam, lParam));
       }
       break;
     case WM_DESTROY:
       PostQuitMessage(0);
       break;
    default:
      return (DefWindowProc(hWnd, message, uParam, lParam));
   }
   return (0);
}
