/*
 *  Copyright (c) by CryptoSoft GmbH 1998-2017
 *  All Rights Reserved
 *  Licensed Material - Property of CryptoSoft GmbH
 *  This software is made available solely pursuant to the
 *  terms of a license agreement which governs its use.
 *
 */

#ifdef WIN32
#include <windows.h>
#endif

#ifdef WIN64
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/timeb.h>
#include "des3.h"

#define BLKSZ  (8)
#define NUMBLK (1000)

static char *algo = "16 round DES";

static unsigned long bufsize = BLKSZ * NUMBLK;
static unsigned long rounds  = BLKSZ * NUMBLK;

static DES_KS ks;

int main(int argc, char **argv)
{
  register unsigned char *b, *buf;
  register int  i, j;
  struct timeb t, t1;
  long ms;

  if ((buf = (unsigned char *) malloc(bufsize)) == NULL) {
    fprintf(stderr,"%s: Error: Cannot alloc memory !\n", argv[0]);
    return 1;
  }
  ftime(&t);
  for (j = 0; j < rounds; j++)
  for (b=buf, i = bufsize; i > 0; i -= BLKSZ , b += BLKSZ) des_ecbencode(b,b,ks);
  ftime(&t1);
  ms = (((long)(t1.time * 1000) + t1.millitm) - ((long)(t.time * 1000) + t.millitm));
  printf("Throughput %lu bytes/s for %s (ECB mode)\n", (unsigned long)(((float)rounds*bufsize)/ms) * 1000, algo);
  free(buf);
  return 0;
}
