/*
 *  Copyright (c) 1998-2015 by CryptoSoft GmbH
 *  All Rights Reserved
 *  Licensed Material - Property of CryptoSoft GmbH
 *  This software is made available solely pursuant to the
 *  terms of a CryptoSoft license agreement which governs its use.
 *
 *  TESTVT.C - DES Variable Text Known Answer Test
 */

#ifdef WIN32
#include <windows.h>
#endif

#ifdef WIN64
#include <windows.h>
#endif

#include <stdio.h>
#include <string.h>

#include "des3.h"	 /* DES function prototypes */

/* size of key, in bytes */
#define KEYSZ	(8)
/* size of standard block, in bytes */
#define	BLKSZ	(8)


static char *algo = "DES";

DES_KS ks;

int main(void)
{
  unsigned char kb[KEYSZ];
  unsigned char pt[BLKSZ], ct[BLKSZ], rt[BLKSZ];
  unsigned int i,j;

  printf("Electronic Codebook (ECB) Mode\nVariable Text Known Answer Tests\n");
  printf("Algorithm: %s\nKeysize=%u Bits\n", algo, KEYSZ*8);

  memset(kb, 0, KEYSZ);
  printf("\nKEY=");
  for (j=0; j < KEYSZ; j++) printf("%02x", kb[j]);
  for (i = 0; i < BLKSZ * 8; i++) {
    memset(pt, 0, BLKSZ);
    pt[i/8] = 0x80 >> i%8;
    des_init(kb, KEYSZ, ks);
    des_ecbencode(pt, ct, ks);
    printf("\n\nI=%u\nPT=", i+1);
    for (j=0; j < BLKSZ; j++) printf("%02x", pt[j]);
    printf("\nCT=");
    for (j=0; j < BLKSZ; j++) printf("%02x", ct[j]);
    des_ecbdecode(ct, rt, ks);
    if (memcmp(pt,rt,BLKSZ)) {
      fprintf(stderr, "\n*** Decryption for round %d failed ***\n", i);
      fprintf(stderr, "\nKEY=");
      for (j=0; j < KEYSZ; j++) fprintf(stderr, "%02x", kb[j]);
      fprintf(stderr, "\nCT=");
      for (j=0; j < BLKSZ; j++) fprintf(stderr, "%02x", ct[j]);
      fprintf(stderr, "\nPT=");
      for (j=0; j < BLKSZ; j++) fprintf(stderr, "%02x", rt[j]);
      fprintf(stderr, "\nOT=");
      for (j=0; j < BLKSZ; j++) fprintf(stderr, "%02x", pt[j]);
      fprintf(stderr,"\n\nNot Succeeded ...\n");
      return 1;
    }
  }
  printf("\n\nSucceeded ...\n");
  return 0;
}
