/*
 *  Copyright (c) by CryptoSoft GmbH 1998-2015
 *  All Rights Reserved
 *  Licensed Material - Property of CryptoSoft GmbH
 *  This software is made available solely pursuant to the
 *  terms of a license agreement which governs its use.
 *
 *  TESTVK.C - Twofish Variable Key Known Answer Test
 */

#if defined(WIN16) || defined(WIN32) || defined(WIN64)
#include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include "twofish.h"	 /* Twofish function prototypes */

/* size of key, in bytes */
#define KEYSZ	(32)
/* size of standard block, in bytes */
#define	BLKSZ	(16)

static char *algo = "Twofish";

TWOFISH_KS ks;

int main(void)
{
  unsigned char kb[KEYSZ];
  unsigned char pt[BLKSZ], ct[BLKSZ];
  unsigned int i,j;

  printf("Electronic Codebook (ECB) Mode\nVariable Key Known Answer Tests\n");
  printf("Algorithm: %s\nKeysize=%u Bits\n", algo, KEYSZ*8);

  memset(pt, 0, BLKSZ);
  printf("\nPT=");
  for (j=0; j < BLKSZ; j++) printf("%02x", pt[j]);

  for (i = 0; i < KEYSZ * 8; i++) {
    memset(kb, 0, KEYSZ);
    kb[i/8] = 0x80 >> i%8;
    twofish_init(kb, KEYSZ, &ks);
    twofish_ecbencode(pt, ct, &ks);
    printf("\n\nI=%u\nKEY=", i+1);
    for (j=0; j < KEYSZ; j++) printf("%02x", kb[j]);
    printf("\nCT=");
    for (j=0; j < BLKSZ; j++) printf("%02x", ct[j]);
  }
  printf("\n");
  return 0;
}
